/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters;

import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import dev.architectury.registry.registries.Registries;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.GameInstance;
import dev.latvian.mods.itemfilters.DisplayStacksCache;
import dev.latvian.mods.itemfilters.ItemFiltersCommon;
import dev.latvian.mods.itemfilters.api.ItemFiltersItems;
import dev.latvian.mods.itemfilters.client.ItemFiltersClient;
import dev.latvian.mods.itemfilters.gui.InventoryFilterMenu;
import dev.latvian.mods.itemfilters.net.ItemFiltersNet;
import dev.latvian.mods.itemfilters.net.MessageClearDisplayCache;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;

public class ItemFilters {
    public static final String MOD_ID = "itemfilters";
    public static ItemFiltersCommon proxy;
    public static CreativeModeTab creativeTab;

    public void setup() {
        proxy = (ItemFiltersCommon)EnvExecutor.getEnvSpecific(() -> ItemFiltersClient::new, () -> ItemFiltersCommon::new);
        creativeTab = CreativeTabRegistry.create((ResourceLocation)new ResourceLocation(MOD_ID, "main"), () -> new ItemStack((ItemLike)ItemFiltersItems.ALWAYS_TRUE.get()));
        ItemFiltersItems.init();
        InventoryFilterMenu.TYPE = Registries.get((String)MOD_ID).get(Registry.f_122913_).register(new ResourceLocation(MOD_ID, "inventory_filter"), () -> MenuRegistry.ofExtended(InventoryFilterMenu::new));
        ItemFiltersNet.init();
        EnvExecutor.runInEnv((Dist)Dist.CLIENT, () -> proxy::setup);
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)new TagReloadListener());
    }

    private static class TagReloadListener
    implements ResourceManagerReloadListener {
        private TagReloadListener() {
        }

        public void m_6213_(ResourceManager resourceManager) {
            DisplayStacksCache.clear();
            MinecraftServer server = GameInstance.getServer();
            if (server != null) {
                MessageClearDisplayCache msg = new MessageClearDisplayCache();
                for (ServerPlayer player : server.m_6846_().m_11314_()) {
                    if (server.m_7779_(player.m_36316_())) continue;
                    ItemFiltersNet.MAIN.sendToPlayer(player, (Object)msg);
                }
            }
        }
    }
}

